/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.FitData;
import util.Logger;
import view.MainView;

public final class FitSlope
extends FitData {
    static Logger logger = Logger.getLogger();
    private double minSlope;
    private double maxSlope;

    public FitSlope(MainView pView, int pnodes, double min, double max) {
        super(pView, pnodes);
        logger.entry(4, "FitSlope.FitSlope");
        this.minSlope = min;
        this.maxSlope = max;
        this.extra = 10;
        this.xout = new double[this.nodesin + 2 * this.extra];
        this.yout = new double[this.nodesin + 2 * this.extra];
        this.xinvert = new double[this.nodesin + 2 * this.extra];
        this.yinvert = new double[this.nodesin + 2 * this.extra];
        logger.exit(4, "FitSlope.FitSlope");
    }

    public void extrapolate() {
        logger.entry(4, "FitSlope.extrapolate");
        int i = 0;
        while (i < this.extra) {
            this.xout[i] = this.xin[this.nodesin - this.extra + i] - 360.0;
            this.yout[i] = this.yin[this.nodesin - this.extra + i] - 360.0;
            ++i;
        }
        i = 0;
        while (i < this.nodesin) {
            this.xout[this.extra + i] = this.xin[i];
            this.yout[this.extra + i] = this.yin[i];
            ++i;
        }
        i = 0;
        while (i < this.extra) {
            this.xout[this.extra + this.nodesin + i] = this.xin[i] + 360.0;
            this.yout[this.extra + this.nodesin + i] = this.yin[i] + 360.0;
            ++i;
        }
        logger.exit(4, "FitSlope.extrapolate");
    }

    private double getSlopeOut(int n) {
        logger.entry(6, "FitSlope.getSlopeOut: " + n);
        double slope = 0.0;
        if (n < this.nodesin) {
            slope = this.yout[this.extra + n] - this.yout[this.extra + n - 1];
            slope /= this.xout[this.extra + n] - this.xout[this.extra + n - 1];
        } else {
            logger.log(1, "FitSlope.getSlope: invalid input n > array bounds");
        }
        logger.exit(6, "FitSlope.getSlopeOut: " + slope);
        return slope;
    }

    private double getNextOrderSlope(int i, int ord) {
        logger.entry(6, "FitSlope.getNextOrderSlope");
        double slope = 0.0;
        if (i + ord < this.yout.length) {
            slope = this.yout[this.extra + i + ord] - this.yout[this.extra + i - 1];
            slope /= this.xout[this.extra + i + ord] - this.xout[this.extra + i - 1];
        } else {
            logger.log(1, "FitData.getNextOrderSlope: out of bounds error");
            slope = 1.0;
        }
        logger.exit(6, "FitData.getNextOrderSlope: " + slope);
        return slope;
    }

    @Override
    public void fitCorr() {
        logger.entry(4, "FitSlope.fitCorr");
        this.extrapolate();
        int i = 0;
        while (i < this.nodesin) {
            int ord = 0;
            double s = this.getSlopeOut(i);
            while (s < this.minSlope || s > this.maxSlope) {
                s = this.getNextOrderSlope(i, ++ord);
            }
            int n = i;
            while (n < i + ord) {
                double delta = this.xout[this.extra + n] - this.xout[this.extra + i - 1];
                double x0 = this.yout[this.extra + i - 1];
                this.yout[this.extra + n] = s * delta + x0;
                ++n;
            }
            i = n + 1;
        }
        this.invert();
        logger.exit(4, "FitSlope.fitCorr");
    }
}

